<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Paragraph extends Model 
{

    protected $table = 'paragraphs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->hasOne('App\Models\Languages');
    }

    public function section()
    {
        return $this->hasOne('App\Models\Section');
    }

    public function paragraphType()
    {
        return $this->hasOne('App\Models\ParagraphType');
    }

}